# 📋 Análise Completa do Projeto - Empreendedor MEI

## 🎯 Visão Geral

Este é um sistema web para regularização de débitos DAS (Documento de Arrecadação do Simples Nacional) de Microempreendedores Individuais (MEI). O sistema permite consultar CNPJ, visualizar débitos pendentes e gerar pagamentos via PIX.

## 📁 Estrutura do Projeto

```
empreendedormei/
├── a.php                      # Página inicial - Consulta CNPJ e exibe status MEI
├── index.html                 # Página inicial (vazia/redirecionamento)
├── minha-conta.php            # Página da conta do usuário autenticado
├── debitos.html               # Lista de débitos DAS em aberto
├── aviso-pagamento.html       # Aviso legal antes do pagamento
├── loading.html               # Tela de carregamento ao gerar fatura PIX
├── fatura.html                # Tela de pagamento PIX com QR Code
├── api/
│   ├── create-payment.php     # API para criar pagamento PIX (mock)
│   └── get-payment.php        # API para verificar status do pagamento (mock)
├── components/
│   ├── Layout.js              # Componente Vue.js para layout base
│   └── Icon.js                # Componente Vue.js para ícones SVG
├── css/
│   └── custom.css             # Estilos customizados e tema gov.br
└── assets/
    ├── mei-logo.png           # Logo MEI
    ├── simples-nacional-logo.png  # Logo Simples Nacional
    └── govbr.webp             # Logo gov.br (footer)
```

## 🛠️ Tecnologias Utilizadas

### Frontend
- **Vue.js 3** (CDN) - Framework JavaScript reativo
- **Tailwind CSS** (CDN) - Framework CSS utilitário
- **HTML5** - Estrutura das páginas
- **JavaScript (ES6+)** - Lógica do frontend

### Backend
- **PHP 7.4+** - Linguagem server-side
- **cURL** - Para requisições HTTP à API externa
- **JSON** - Formato de dados

### APIs Externas
- **OpenCNPJ API** (`https://kitana.opencnpj.com/cnpj/`) - Consulta de CNPJ (API pública, 100 consultas/minuto)
- **PayFort PIX** - Gateway de pagamento PIX (Cash-In)
- **QR Code Generator** - Geração de QR Codes para PIX

## 🔄 Fluxo de Funcionamento

### 1. Autenticação Inicial (`a.php`)
- Usuário acessa com parâmetro CNPJ: `a.php?cnpj=12345678000190`
- Sistema consulta API OpenCNPJ para obter dados da empresa
- Dados são salvos no `localStorage` do navegador
- Redireciona para `minha-conta.php` após 2 segundos

### 2. Minha Conta (`minha-conta.php`)
- Exibe status do MEI (INATIVO)
- Mostra dados da empresa (CNPJ e Razão Social)
- Botão "Ver meus débitos" redireciona para `debitos.html`

### 3. Lista de Débitos (`debitos.html`)
- Lista débitos DAS em aberto (hardcoded no código)
- Calcula total de débitos pendentes
- Botão "Regularizar agora" redireciona para `aviso-pagamento.html`

### 4. Aviso de Pagamento (`aviso-pagamento.html`)
- Exibe avisos legais sobre consequências do não pagamento
- Botão "Emitir DAS" redireciona para `loading.html`

### 5. Geração de PIX (`loading.html`)
- Faz requisição para `api/create-payment.php`
- Cria código PIX e salva no `localStorage`
- Mostra barra de progresso animada
- Redireciona para `fatura.html` após 3 segundos

### 6. Pagamento PIX (`fatura.html`)
- Exibe código PIX "copia e cola"
- Gera QR Code para pagamento
- Verifica status do pagamento a cada 10 segundos via `api/get-payment.php`
- Após confirmação, redireciona para página de confirmação

## 📝 Funcionalidades Principais

### ✅ Implementadas
1. Consulta de CNPJ via API OpenCNPJ
2. Exibição de dados da empresa MEI
3. Lista de débitos DAS
4. Geração de código PIX
5. QR Code para pagamento
6. Verificação de status de pagamento
7. Interface responsiva com Vue.js e Tailwind CSS
8. Tema gov.br (azul institucional)

### ⚠️ Observações Importantes
1. **APIs de Pagamento Mockadas**: Os arquivos `api/create-payment.php` e `api/get-payment.php` retornam dados hardcoded. Para produção, é necessário integrar com uma API de pagamento real (como Ecomovi, Mercado Pago, PagSeguro, etc.)

2. **Dados de Débitos Hardcoded**: A lista de débitos está fixa no código (`debitos.html`). Em produção, deve vir de uma base de dados ou API.

3. **Autenticação Simplificada**: A autenticação é feita apenas via CNPJ na URL e dados salvos no `localStorage`. Não há sistema de sessão server-side.

4. **API OpenCNPJ**: API pública gratuita e rápida com limite de 100 consultas por minuto. Não requer autenticação.

## 🔒 Segurança

### Pontos de Atenção
- ❌ Dados sensíveis no `localStorage` (pode ser acessado via JavaScript)
- ❌ Sem validação server-side adequada
- ❌ APIs retornando dados mockados (não válidos para produção)
- ❌ Sem proteção CSRF
- ❌ Sem sanitização de inputs do usuário

### Recomendações
- Implementar autenticação server-side com sessões PHP
- Validar e sanitizar todos os inputs
- Usar HTTPS em produção
- Implementar rate limiting nas APIs
- Adicionar logs de auditoria
- Proteger APIs com tokens de autenticação

## 🎨 Design System

O projeto utiliza um design system baseado no padrão gov.br:
- **Cores principais**: Azul institucional (#003366, #004080)
- **Cor de sucesso**: Verde (#7CB342)
- **Cor de erro**: Vermelho (HSL: 0 84% 60%)
- **Tipografia**: Roboto (via sistema)
- **Componentes**: Layout com header, footer gov.br, cards, botões

## 📊 Armazenamento de Dados

### LocalStorage
- `meiData`: Dados da empresa MEI (CNPJ, razão social)
- `currentTransaction`: Dados da transação PIX atual
- `boleto_payment_confirmed`: Confirmação de pagamento

### Não há Base de Dados
O projeto atual não utiliza banco de dados. Todos os dados são:
- Consultados via APIs externas (CNPJ)
- Armazenados temporariamente no `localStorage`
- Retornados como JSON hardcoded nas APIs

## 🚀 Próximos Passos para Produção

1. **Integrar API de Pagamento Real**
   - Ecomovi, Mercado Pago, PagSeguro, etc.
   - Implementar webhooks para notificações

2. **Implementar Banco de Dados**
   - MySQL/PostgreSQL para armazenar:
     - Dados de empresas
     - Histórico de débitos
     - Transações de pagamento
     - Logs de acesso

3. **Sistema de Autenticação**
   - Login com gov.br
   - Sessões PHP seguras
   - Refresh tokens

4. **Validações e Segurança**
   - Validação de CNPJ
   - Sanitização de inputs
   - Proteção CSRF
   - Rate limiting

5. **Testes**
   - Testes unitários
   - Testes de integração
   - Testes de segurança

## 📦 Dependências Externas

### CDNs Utilizadas
- Vue.js 3: `https://unpkg.com/vue@3/dist/vue.global.js`
- Tailwind CSS: `https://cdn.tailwindcss.com`
- QR Code: `https://cdn.jsdelivr.net/npm/qrcode@1.5.3/build/qrcode.min.js`

### APIs Externas
- OpenCNPJ: `https://kitana.opencnpj.com/cnpj/{cnpj}` (100 consultas/min)
- QR Code Generator: `https://api.qrserver.com/v1/create-qr-code/`

## 🔍 Arquivos Chave

### `a.php` - Ponto de Entrada Principal
- Consulta CNPJ via API OpenCNPJ (rápida e confiável)
- Valida dados
- Renderiza página com Vue.js
- Salva dados no localStorage

### `api/create-payment.php` - Criação de Pagamento
- **Atual**: Retorna JSON hardcoded
- **Deve**: Criar transação PIX na API de pagamento
- Retorna código PIX e transaction_id

### `api/get-payment.php` - Status do Pagamento
- **Atual**: Retorna JSON hardcoded
- **Deve**: Consultar status na API de pagamento
- Retorna status: `waiting_payment`, `paid`, `approved`, `expired`, `cancelled`

---

**Data da Análise**: Janeiro 2025  
**Versão do Projeto**: 1.0.0 (Desenvolvimento)

